#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/************************************************************************
*    Function Name:  ConfigIntOC4                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/

void ConfigIntOC4(unsigned int config)
{
    IFS1bits.OC4IF = 0;                   /* Clear IF bit */
    IPC5bits.OC4IP = (config &0x0007);    /* Assign Interrupt Priority */ 
    IEC1bits.OC4IE = (config &0x0008)>> 3;/* Enable/disable Interrupt */
}

#endif 
